<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Run admin user seeder to ensure admin login works
        $this->call([
            AdminUserSeeder::class,
            PaymentGatewaysSeeder::class,
            ComprehensiveCategoriesSeeder::class,
            CategoryFieldsSeeder::class,
            MonetizationSeeder::class, // Auto-populate ad units on fresh migrations
            PagesSeeder::class, // Create default pages (About, Terms, Privacy, etc.)
        ]);

        // Run our user plans seeder
        $this->call(UserPlansSeeder::class);

        // Run our initial data seeder
        $this->call(InitialDataSeeder::class);

        // Create some test users
        User::factory(5)->create();
    }
}
