<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Category;
use App\Models\Subcategory;

class ComprehensiveCategoriesSeeder extends Seeder
{
    public function run(): void
    {
        // Disable foreign key checks to allow cleanup
        \Illuminate\Support\Facades\Schema::disableForeignKeyConstraints();
        
        $this->command->info('Cleaning up old categories...');
        Category::query()->delete();
        Subcategory::query()->delete();
        // Reset auto-increment
        if (\Illuminate\Support\Facades\DB::getDriverName() === 'sqlite') {
            \Illuminate\Support\Facades\DB::update("DELETE FROM sqlite_sequence WHERE name = 'categories'");
            \Illuminate\Support\Facades\DB::update("DELETE FROM sqlite_sequence WHERE name = 'subcategories'");
        }

        \Illuminate\Support\Facades\Schema::enableForeignKeyConstraints();

        $categories = [
            [
                'name' => 'Cars',
                'icon' => '🚗',
                'subcategories' => [
                    ['name' => 'EV - Electric Vehicles Cars', 'icon' => '⚡'],
                    ['name' => 'Commercial Car - Yellow Board', 'icon' => '🚕'],
                    ['name' => 'Personal Cars - White Board', 'icon' => '🚘'],
                    ['name' => 'Luxury Cars', 'icon' => '💎'],
                    ['name' => 'Sports Cars', 'icon' => '🏎️'],
                    ['name' => 'Car Spare Parts', 'icon' => '🔧'],
                    ['name' => 'Other Cars', 'icon' => '🚗'],
                ] 
            ],
            [
                'name' => 'Bikes',
                'icon' => '🏍️',
                'subcategories' => [
                    ['name' => 'Motorcycles', 'icon' => '🏍️'],
                    ['name' => 'Scooters', 'icon' => '🛵'],
                    ['name' => 'EV - Electric Bike', 'icon' => '⚡'],
                    ['name' => 'Bike Spare Parts', 'icon' => '⚙️'],
                    ['name' => 'Bicycles', 'icon' => '🚲']
                ]
            ],
            [
                'name' => 'Properties',
                'icon' => '🏢',
                'subcategories' => [
                    ['name' => 'For Sale: Houses & Apartments', 'icon' => '🏠'],
                    ['name' => 'For Rent: Houses & Apartments', 'icon' => '🏘️'],
                    ['name' => 'Lands & Plots', 'icon' => '🏞️'],
                    ['name' => 'New Projects', 'icon' => '🏗️'],
                    ['name' => 'For Rent: Shops & Offices', 'icon' => '🏢'],
                    ['name' => 'For Sale: Shops & Offices', 'icon' => '🏪'],
                    ['name' => 'PG & Guest Houses', 'icon' => '🛌']
                ]
            ],
            [
                'name' => 'Electronics & Appliances',
                'icon' => '📺',
                'subcategories' => [
                    ['name' => 'TVs, Video - Audio', 'icon' => '📺'],
                    ['name' => 'Kitchen & Other Appliances', 'icon' => '🍳'],
                    ['name' => 'Computers & Laptops', 'icon' => '💻'],
                    ['name' => 'Cameras & Lenses', 'icon' => '📷'],
                    ['name' => 'Games & Entertainment', 'icon' => '🎮'],
                    ['name' => 'Fridges', 'icon' => '🧊'],
                    ['name' => 'Computer Accessories', 'icon' => '⌨️'],
                    ['name' => 'Hard Disks, Printers & Monitors', 'icon' => '🖨️'],
                    ['name' => 'ACs', 'icon' => '❄️'],
                    ['name' => 'Washing Machines', 'icon' => '🧺']
                ]
            ],
            [
                'name' => 'Mobiles',
                'icon' => '📱',
                'subcategories' => [
                    ['name' => 'Mobile Phones', 'icon' => '📱'],
                    ['name' => 'Accessories', 'icon' => '🎧'],
                    ['name' => 'Tablets', 'icon' => '📲']
                ]
            ],
            [
                'name' => 'Commercial Vehicles & Spares',
                'icon' => '🚛',
                'subcategories' => [
                    ['name' => 'Commercial & Other Vehicles', 'icon' => '🚛'],
                    ['name' => 'Commercial Spares', 'icon' => '🔩']
                ]
            ],
            [
                'name' => 'Jobs',
                'icon' => '💼',
                'subcategories' => [
                    ['name' => 'Data entry & Back office', 'icon' => '⌨️'],
                    ['name' => 'Sales & Marketing', 'icon' => '📈'],
                    ['name' => 'BPO & Telecaller', 'icon' => '📞'],
                    ['name' => 'Driver', 'icon' => '🚚'],
                    ['name' => 'Office Assistant', 'icon' => '💼'],
                    ['name' => 'Delivery & Collection', 'icon' => '📦'],
                    ['name' => 'Teacher', 'icon' => '👨‍🏫'],
                    ['name' => 'Cook', 'icon' => '🍳'],
                    ['name' => 'Receptionist & Front office', 'icon' => '💁'],
                    ['name' => 'Operator & Technician', 'icon' => '🔧'],
                    ['name' => 'IT Engineer & Developer', 'icon' => '💻'],
                    ['name' => 'Hotel & Travel Executive', 'icon' => '🏨'],
                    ['name' => 'Accountant', 'icon' => '📊'],
                    ['name' => 'Warehouse Staff', 'icon' => '🏭'],
                    ['name' => 'Designer', 'icon' => '🎨'],
                    ['name' => 'Other Jobs', 'icon' => '➕']
                ]
            ],
            [
                'name' => 'Furniture',
                'icon' => '🪑',
                'subcategories' => [
                    ['name' => 'Sofa & Dining', 'icon' => '🛋️'],
                    ['name' => 'Beds & Wardrobes', 'icon' => '🛏️'],
                    ['name' => 'Home Decor & Garden', 'icon' => '🪴'],
                    ['name' => 'Kids Furniture', 'icon' => '🧸'],
                    ['name' => 'Other Household Items', 'icon' => '🚪']
                ]
            ],
            [
                'name' => 'Fashion',
                'icon' => '👗',
                'subcategories' => [
                    ['name' => 'Men', 'icon' => '👕'],
                    ['name' => 'Women', 'icon' => '👗'],
                    ['name' => 'Kids', 'icon' => '👶']
                ]
            ],
            [
                'name' => 'Pets',
                'icon' => '🐾',
                'subcategories' => [
                    ['name' => 'Fishes & Aquarium', 'icon' => '🐠'],
                    ['name' => 'Pet Food & Accessories', 'icon' => '🦴'],
                    ['name' => 'Dogs', 'icon' => '🐕'],
                    ['name' => 'Other Pets', 'icon' => '🐇']
                ]
            ],
            [
                'name' => 'Books, Sports & Hobbies',
                'icon' => '🎸',
                'subcategories' => [
                    ['name' => 'Books', 'icon' => '📚'],
                    ['name' => 'Gym & Fitness', 'icon' => '💪'],
                    ['name' => 'Musical Instruments', 'icon' => '🎸'],
                    ['name' => 'Sports Equipment', 'icon' => '⚽'],
                    ['name' => 'Other Hobbies', 'icon' => '🎨']
                ]
            ],
            [
                'name' => 'Services',
                'icon' => '🔧',
                'subcategories' => [
                    ['name' => 'Education & Classes', 'icon' => '🎓'],
                    ['name' => 'Tours & Travel', 'icon' => '✈️'],
                    ['name' => 'Electronics Repair & Services', 'icon' => '🛠️'],
                    ['name' => 'Health & Beauty', 'icon' => '💄'],
                    ['name' => 'Home Renovation & Repair', 'icon' => '🔨'],
                    ['name' => 'Cleaning & Pest Control', 'icon' => '🧹'],
                    ['name' => 'Legal & Documentation Services', 'icon' => '⚖️'],
                    ['name' => 'Packers & Movers', 'icon' => '📦'],
                    ['name' => 'Other Services', 'icon' => '🤝']
                ]
            ],
            [
                'name' => 'Game ID',
                'icon' => '🎮',
                'subcategories' => [
                    ['name' => 'BGMI', 'icon' => '🔫'],
                    ['name' => 'FreeFire', 'icon' => '🔥'],
                    ['name' => 'COD', 'icon' => '🎯'],
                    ['name' => 'Valorant', 'icon' => '⚔️'],
                    ['name' => 'Marvels Rivals', 'icon' => '🦸']
                ]
            ],
            [
                'name' => 'Social Media Accounts',
                'icon' => '🤳',
                'subcategories' => [
                    ['name' => 'Instagram', 'icon' => '📸'],
                    ['name' => 'Youtube', 'icon' => '📹'],
                    ['name' => 'X - Twitter', 'icon' => '🐦'],
                    ['name' => 'facebook', 'icon' => '👥']
                ]
            ]
        ];

        foreach ($categories as $catData) {
            $this->command->info("Creating category: {$catData['name']}");
            
            $category = Category::create([
                'name' => $catData['name'],
                'icon' => $catData['icon'],
                // slug is handled by model boot event
            ]);

            foreach ($catData['subcategories'] as $subData) {
                Subcategory::create([
                    'category_id' => $category->id,
                    'name' => $subData['name'],
                    'icon' => $subData['icon'],
                    // slug is handled by model boot event
                ]);
            }
        }
    }
}
