<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\Subcategory;
use Illuminate\Support\Str;

class CategoriesSeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            'Electronics' => [
                'icon' => '📱',
                'subcategories' => ['Mobile Phones', 'Laptops & Computers', 'Cameras', 'TVs & Audio', 'Gaming Consoles', 'Accessories']
            ],
            'Vehicles' => [
                'icon' => '🚗',
                'subcategories' => ['Cars', 'Motorcycles', 'Bicycles', 'Commercial Vehicles', 'Auto Parts & Accessories']
            ],
            'Real Estate' => [
                'icon' => '🏠',
                'subcategories' => ['Apartments for Sale', 'Apartments for Rent', 'Houses for Sale', 'Houses for Rent', 'Commercial Property', 'Land & Plots']
            ],
            'Jobs' => [
                'icon' => '💼',
                'subcategories' => ['IT & Software', 'Sales & Marketing', 'Healthcare', 'Education', 'Engineering', 'Customer Service', 'Part Time Jobs']
            ],
            'Services' => [
                'icon' => '🔧',
                'subcategories' => ['Home Services', 'Repair & Maintenance', 'Health & Beauty', 'Event Services', 'Tutors & Classes', 'Packers & Movers']
            ],
            'Furniture & Home Decor' => [
                'icon' => '🛋️',
                'subcategories' => ['Sofas & Chairs', 'Beds & Wardrobes', 'Tables & Dining', 'Home Decor', 'Garden & Outdoor', 'Kitchen Appliances']
            ],
            'Fashion & Beauty' => [
                'icon' => '👗',
                'subcategories' => ['Men\'s Clothing', 'Women\'s Clothing', 'Kids & Baby', 'Footwear', 'Watches & Jewelry', 'Bags & Accessories']
            ],
            'Books, Sports & Hobbies' => [
                'icon' => '📚',
                'subcategories' => ['Books', 'Sports Equipment', 'Musical Instruments', 'Gym & Fitness', 'Art & Collectibles']
            ],
            'Pets' => [
                'icon' => '🐾',
                'subcategories' => ['Dogs', 'Cats', 'Birds', 'Fish & Aquarium', 'Pet Accessories', 'Pet Services']
            ]
        ];

        foreach ($categories as $categoryName => $data) {
            $category = Category::updateOrCreate(
                ['name' => $categoryName],
                [
                    'slug' => Str::slug($categoryName),
                    'icon' => $data['icon'],
                    'description' => "Browse {$categoryName} listings",
                    'is_active' => true,
                    'sort_order' => array_search($categoryName, array_keys($categories))
                ]
            );

            foreach ($data['subcategories'] as $index => $subcategoryName) {
                Subcategory::updateOrCreate(
                    [
                        'category_id' => $category->id,
                        'name' => $subcategoryName
                    ],
                    [
                        'slug' => Str::slug($subcategoryName),
                        'description' => "Find {$subcategoryName}",
                        'is_active' => true,
                        'sort_order' => $index
                    ]
                );
            }
        }

        $this->command->info('✅ Categories and subcategories created successfully!');
    }
}
