<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\BlogCategory;

class BlogCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Tips & Tricks',
                'slug' => 'tips-tricks',
                'description' => 'Helpful tips and tricks for using the platform effectively',
                'icon' => '💡',
                'color' => '#f59e0b',
                'order' => 1,
            ],
            [
                'name' => 'Product Reviews',
                'slug' => 'product-reviews',
                'description' => 'In-depth reviews of products and services',
                'icon' => '⭐',
                'color' => '#8b5cf6',
                'order' => 2,
            ],
            [
                'name' => 'User Stories',
                'slug' => 'user-stories',
                'description' => 'Success stories and experiences from our community',
                'icon' => '📖',
                'color' => '#10b981',
                'order' => 3,
            ],
            [
                'name' => 'Platform Updates',
                'slug' => 'platform-updates',
                'description' => 'Latest updates and new features on CLX Pro',
                'icon' => '🚀',
                'color' => '#3b82f6',
                'order' => 4,
            ],
            [
                'name' => 'How-To Guides',
                'slug' => 'how-to-guides',
                'description' => 'Step-by-step guides for various tasks',
                'icon' => '📚',
                'color' => '#ef4444',
                'order' => 5,
            ],
            [
                'name' => 'News & Announcements',
                'slug' => 'news-announcements',
                'description' => 'Important news and announcements',
                'icon' => '📢',
                'color' => '#ec4899',
                'order' => 6,
            ],
        ];

        foreach ($categories as $category) {
            BlogCategory::updateOrCreate(
                ['slug' => $category['slug']],
                $category
            );
        }
    }
}
