<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BannerPackageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $packages = [
            [
                'name' => 'Basic Banner',
                'description' => 'Perfect for small businesses and local targeting',
                'base_price_per_impression' => 0.001000,
                'base_price_per_click' => 0.05,
                'max_impressions_included' => 10000,
                'max_clicks_included' => null,
                'features' => [
                    'Basic analytics',
                    'Single location targeting',
                    'Standard placement'
                ],
                'discount_percentage' => 20.00,
                'promotional_text' => 'Save 20%!',
                'is_active' => true,
                'display_order' => 1
            ],
            [
                'name' => 'Standard Banner',
                'description' => 'Great for growing businesses with multi-location reach',
                'base_price_per_impression' => 0.000800,
                'base_price_per_click' => 0.04,
                'max_impressions_included' => 50000,
                'max_clicks_included' => null,
                'features' => [
                    'Advanced analytics',
                    'Multi-location targeting',
                    'Priority placement',
                    'Performance insights'
                ],
                'discount_percentage' => 30.00,
                'promotional_text' => 'Most Popular - Save 30%!',
                'is_active' => true,
                'display_order' => 2
            ],
            [
                'name' => 'Premium Banner',
                'description' => 'Maximum exposure for serious brands and nationwide campaigns',
                'base_price_per_impression' => 0.000500,
                'base_price_per_click' => 0.03,
                'max_impressions_included' => 200000,
                'max_clicks_included' => null,
                'features' => [
                    'Real-time analytics',
                    'Nationwide targeting',
                    'Highest priority placement',
                    'Dedicated support',
                    'A/B testing ready',
                    'Advanced reporting'
                ],
                'discount_percentage' => 60.00,
                'promotional_text' => 'Best Value - Save 60%!',
                'is_active' => true,
                'display_order' => 3
            ]
        ];

        foreach ($packages as $package) {
            \App\Models\BannerPackage::create($package);
        }
    }
}
