<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create persistent admin user with guaranteed access
        $adminUser = User::updateOrCreate(
            ['email' => 'admin@donebro.in'],
            [
                'name' => 'Admin User',
                'password' => Hash::make('123456'),
                'is_admin' => true,
                'is_verified' => true,
                'current_plan_id' => null, // Admin doesn't need a plan
                'remember_token' => null,
            ]
        );

        // Create some sample users for testing
        User::updateOrCreate(
            ['email' => 'john@example.com'],
            [
                'name' => 'John Doe',
                'password' => Hash::make('password123'),
                'is_admin' => false,
                'is_verified' => true,
                'current_plan_id' => 1, // VIP Pro
            ]
        );

        User::updateOrCreate(
            ['email' => 'jane@example.com'],
            [
                'name' => 'Jane Smith',
                'password' => Hash::make('password123'),
                'is_admin' => false,
                'is_verified' => true,
                'current_plan_id' => 2, // VIP Buyer
            ]
        );
    }
}
