<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->integer('featured_ads_used')->default(0)->after('remember_token')->comment('Featured ads used this cycle');
            $table->integer('boost_ads_used')->default(0)->after('featured_ads_used')->comment('Boost ads used this cycle');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['featured_ads_used', 'boost_ads_used']);
        });
    }
};
