<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_plans', function (Blueprint $table) {
            $table->integer('featured_limit')->default(0)->after('status')->comment('Monthly free featured ads limit');
            $table->integer('boost_limit')->default(0)->after('featured_limit')->comment('Monthly free boost ads limit');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_plans', function (Blueprint $table) {
            $table->dropColumn(['featured_limit', 'boost_limit']);
        });
    }
};
