<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->integer('leads_received')->default(0)->after('mobile_number');
            $table->integer('contacts_initiated')->default(0)->after('leads_received');
            $table->timestamp('cycle_reset_at')->nullable()->after('contacts_initiated');
        });

        Schema::table('user_plans', function (Blueprint $table) {
            $table->integer('contact_limit')->nullable()->default(0)->after('lead_limit');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['leads_received', 'contacts_initiated', 'cycle_reset_at']);
        });

        Schema::table('user_plans', function (Blueprint $table) {
            $table->dropColumn('contact_limit');
        });
    }
};
