<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('chat_messages', function (Blueprint $table) {
            $table->boolean('is_flagged')->default(false)->after('attachment_type');
            $table->string('flag_reason')->nullable()->after('is_flagged');
            $table->integer('risk_score')->default(0)->after('flag_reason');
        });
    }

    public function down(): void
    {
        Schema::table('chat_messages', function (Blueprint $table) {
            $table->dropColumn(['is_flagged', 'flag_reason', 'risk_score']);
        });
    }
};
