<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guardian_logs', function (Blueprint $table) {
            $table->id();
            $table->string('action'); // BAN, SUSPEND, REJECT, WARN
            $table->string('target_type'); // User, Ad
            $table->unsignedBigInteger('target_id');
            $table->text('reason');
            $table->json('snapshot')->nullable(); // Store ad content or user data at time of action
            $table->boolean('is_overwritten')->default(false);
            $table->unsignedBigInteger('admin_id')->nullable(); // Who overwrote it
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guardian_logs');
    }
};
