<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ad_units', function (Blueprint $table) {
            $table->integer('frequency')->default(10)->after('is_active');
            $table->integer('grid_frequency')->default(8)->after('frequency');
        });

        Schema::table('ad_networks', function (Blueprint $table) {
            $table->integer('priority')->default(0)->after('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ad_units', function (Blueprint $table) {
            $table->dropColumn(['frequency', 'grid_frequency']);
        });

        Schema::table('ad_networks', function (Blueprint $table) {
            $table->dropColumn('priority');
        });
    }
};
