<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('banners', function (Blueprint $table) {
            $table->decimal('target_latitude', 10, 8)->nullable()->after('target_cities');
            $table->decimal('target_longitude', 11, 8)->nullable()->after('target_latitude');
            $table->decimal('target_radius', 8, 2)->nullable()->comment('Radius in KM')->after('target_longitude');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('banners', function (Blueprint $table) {
            $table->dropColumn(['target_latitude', 'target_longitude', 'target_radius']);
        });
    }
};
