<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_analytics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->unsignedBigInteger('package_id')->comment('Package/boost purchased');
            $table->timestamp('activated_at');
            $table->timestamp('expires_at');
            $table->integer('total_impressions')->default(0);
            $table->integer('total_views')->default(0);
            $table->integer('total_clicks')->default(0);
            $table->decimal('roi_score', 5, 2)->default(0)->comment('Performance score 0-10');
            $table->enum('status', ['active', 'expired', 'cancelled'])->default('active');
            $table->timestamps();
            
            // Indexes
            $table->index(['user_id', 'status']);
            $table->index('activated_at');
            $table->index('expires_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_analytics');
    }
};
