<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ad_analytics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ad_id')->constrained()->onDelete('cascade');
            $table->date('date');
            $table->integer('impressions')->default(0)->comment('Ad shown in search/feed');
            $table->integer('views')->default(0)->comment('Detail page visits');
            $table->integer('clicks')->default(0)->comment('CTA clicks (call/WhatsApp/contact)');
            $table->decimal('ctr', 5, 2)->default(0)->comment('Click-through rate percentage');
            $table->integer('unique_viewers')->default(0)->comment('Unique users who viewed');
            $table->integer('avg_time_spent')->default(0)->comment('Average seconds on ad page');
            $table->decimal('bounce_rate', 5, 2)->default(0)->comment('Immediate exit percentage');
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['ad_id', 'date']);
            $table->index('date');
            $table->unique(['ad_id', 'date']); // One record per ad per day
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ad_analytics');
    }
};
