<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Insert default settings for Location Range
        DB::table('settings')->insert([
            [
                'key' => 'location_range_min',
                'value' => '5',
                'description' => 'Minimum location range in KM for ad filtering',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'location_range_max',
                'value' => '100',
                'description' => 'Maximum location range in KM for ad filtering',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'location_range_default',
                'value' => '10',
                'description' => 'Default location range in KM',
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('settings')
            ->whereIn('key', ['location_range_min', 'location_range_max', 'location_range_default'])
            ->delete();
    }
};
