<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('banner_packages', function (Blueprint $table) {
            $table->boolean('is_cpm_enabled')->default(true)->after('description'); // Charge by Views
            $table->boolean('is_cpc_enabled')->default(false)->after('is_cpm_enabled'); // Charge by Clicks
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('banner_packages', function (Blueprint $table) {
            $table->dropColumn(['is_cpm_enabled', 'is_cpc_enabled']);
        });
    }
};
