<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('banner_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('banner_id')->constrained()->onDelete('cascade');
            $table->foreignId('package_id')->nullable()->constrained('banner_packages')->onDelete('set null');
            $table->enum('transaction_type', ['purchase', 'refund', 'deduction'])->default('purchase');
            $table->decimal('amount', 10, 2);
            $table->integer('impressions_purchased')->nullable();
            $table->integer('clicks_purchased')->nullable();
            $table->string('payment_method')->nullable();
            $table->enum('payment_status', ['pending', 'completed', 'failed', 'refunded'])->default('pending');
            $table->json('payment_gateway_response')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['user_id', 'created_at']);
            $table->index('banner_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('banner_transactions');
    }
};
