<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('banners', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade');
            $table->foreignId('package_id')->nullable()->constrained('banner_packages')->onDelete('set null');
            $table->string('title');
            $table->string('image_url');
            
            // Redirect configuration
            $table->enum('redirect_type', ['category', 'package', 'plan', 'url', 'ad', 'user_profile', 'static'])->default('static');
            $table->string('redirect_value')->nullable();
            
            // Billing
            $table->enum('billing_model', ['impression', 'click'])->default('impression');
            
            // Location Targeting
            $table->enum('target_location_type', ['all', 'country', 'state', 'city'])->default('all');
            $table->json('target_countries')->nullable();
            $table->json('target_states')->nullable();
            $table->json('target_cities')->nullable();
            
            // Budget & Metrics
            $table->decimal('total_budget', 10, 2)->default(0);
            $table->decimal('cost_per_impression', 10, 6)->nullable();
            $table->decimal('cost_per_click', 10, 2)->nullable();
            $table->decimal('spent_amount', 10, 2)->default(0);
            $table->integer('total_impressions')->default(0);
            $table->integer('total_clicks')->default(0);
            $table->decimal('ctr', 5, 2)->default(0); // Click-through rate percentage
            
            // Goals & Lifecycle
            $table->enum('goal_type', ['impressions', 'clicks', 'budget', 'date_range'])->nullable();
            $table->integer('goal_impressions')->nullable();
            $table->integer('goal_clicks')->nullable();
            $table->decimal('goal_budget', 10, 2)->nullable();
            $table->timestamp('start_date')->nullable();
            $table->timestamp('end_date')->nullable();
            
            // Status & Management
            $table->enum('status', ['draft', 'pending_approval', 'active', 'paused', 'completed', 'rejected'])->default('draft');
            $table->text('admin_notes')->nullable();
            $table->boolean('is_admin_created')->default(false);
            $table->integer('priority')->default(0);
            
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes for performance
            $table->index('status');
            $table->index('is_admin_created');
            $table->index(['user_id', 'status']);
            $table->index('priority');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('banners');
    }
};
