<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('banner_packages', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('base_price_per_impression', 10, 6)->nullable();
            $table->decimal('base_price_per_click', 10, 2)->nullable();
            $table->integer('max_impressions_included')->nullable();
            $table->integer('max_clicks_included')->nullable();
            $table->json('features')->nullable();
            $table->decimal('discount_percentage', 5, 2)->default(0);
            $table->string('promotional_text')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('display_order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('banner_packages');
    }
};
