<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('user_plans', function (Blueprint $table) {
            $table->boolean('is_default')->default(false)->after('status');
        });

        // Set Standard plan as default
        DB::table('user_plans')
            ->where('plan_name', 'Standard')
            ->update(['is_default' => true]);
    }

    public function down(): void
    {
        Schema::table('user_plans', function (Blueprint $table) {
            $table->dropColumn('is_default');
        });
    }
};
