<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('support_settings', function (Blueprint $table) {
            $table->id();
            $table->string('support_email')->default('clx@donebroin');
            $table->string('support_phone')->default('+91 6366704302');
            $table->boolean('ticket_enabled')->default(true);
            $table->boolean('chat_enabled')->default(true);
            $table->boolean('email_enabled')->default(true);
            $table->boolean('call_enabled')->default(true);
            $table->json('business_hours')->nullable(); // {mon: "9-18", tue: "9-18", ...}
            $table->text('auto_reply_message')->nullable();
            $table->text('ticket_instructions')->nullable(); // Instructions shown to users
            $table->integer('avg_response_time_hours')->default(24); // SLA
            $table->timestamps();
        });
        
        // Insert default settings
        DB::table('support_settings')->insert([
            'support_email' => 'clx@donebroin',
            'support_phone' => '+91 6366704302',
            'ticket_enabled' => true,
            'chat_enabled' => true,
            'email_enabled' => true,
            'call_enabled' => true,
            'business_hours' => json_encode([
                'monday' => '09:00-18:00',
                'tuesday' => '09:00-18:00',
                'wednesday' => '09:00-18:00',
                'thursday' => '09:00-18:00',
                'friday' => '09:00-18:00',
                'saturday' => 'Closed',
                'sunday' => 'Closed'
            ]),
            'auto_reply_message' => 'Thank you for contacting CLX support. We have received your ticket and will respond within 24 hours.',
            'created_at' => now(),
            'updated_at' => now()
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_settings');
    }
};
