<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'is_banned')) $table->boolean('is_banned')->default(false)->after('is_verified');
            if (!Schema::hasColumn('users', 'ban_reason')) $table->text('ban_reason')->nullable()->after('is_banned');
            if (!Schema::hasColumn('users', 'banned_until')) $table->timestamp('banned_until')->nullable()->after('ban_reason');
            if (!Schema::hasColumn('users', 'is_suspended')) $table->boolean('is_suspended')->default(false)->after('banned_until');
            if (!Schema::hasColumn('users', 'suspension_reason')) $table->text('suspension_reason')->nullable()->after('is_suspended');
            if (!Schema::hasColumn('users', 'suspended_until')) $table->timestamp('suspended_until')->nullable()->after('suspension_reason');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['is_banned', 'ban_reason', 'banned_until', 'is_suspended', 'suspension_reason', 'suspended_until']);
        });
    }
};
