<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('excerpt')->nullable();
            $table->longText('content'); // Rich text HTML content
            $table->string('featured_image')->nullable();
            
            // Author (admin user)
            $table->foreignId('author_id')->nullable()->constrained('users')->onDelete('set null');
            
            // Category
            $table->foreignId('blog_category_id')->nullable()->constrained('blog_categories')->onDelete('set null');
            
            // Optional associations
            $table->foreignId('user_plan_id')->nullable()->constrained('user_plans')->onDelete('set null');
            $table->foreignId('package_id')->nullable()->constrained('ad_packages')->onDelete('set null');
            
            // Publishing
            $table->boolean('is_published')->default(false);
            $table->timestamp('published_at')->nullable();
            
            // SEO
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('meta_keywords')->nullable();
            
            // Ad Units - references to ad_units table
            $table->unsignedBigInteger('ad_unit_top_banner_id')->nullable();
            $table->unsignedBigInteger('ad_unit_in_content_native_id')->nullable();
            $table->unsignedBigInteger('ad_unit_bottom_interstitial_id')->nullable();
            
            // Stats
            $table->integer('views_count')->default(0);
            $table->integer('likes_count')->default(0);
            
            $table->timestamps();
            
            // Indexes for performance
            $table->index('slug');
            $table->index('is_published');
            $table->index('published_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
