<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ads', function (Blueprint $table) {
            // Check if columns don't exist before adding
            if (!Schema::hasColumn('ads', 'package_purchase_id')) {
                // Package-related fields (no foreign key to avoid circular dependency)
                $table->unsignedBigInteger('package_purchase_id')->nullable()->index();
            }
            
            if (!Schema::hasColumn('ads', 'is_featured')) {
                // Featured ad fields
                $table->boolean('is_featured')->default(false)->index();
                $table->timestamp('featured_until')->nullable()->index();
            }
            
            if (!Schema::hasColumn('ads', 'boost_count_remaining')) {
                // Boost fields
                $table->integer('boost_count_remaining')->default(0);
                $table->timestamp('last_boosted_at')->nullable()->index();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ads', function (Blueprint $table) {
            $table->dropColumn([
                'package_purchase_id',
                'is_featured',
                'featured_until',
                'boost_count_remaining',
                'last_boosted_at'
            ]);
        });
    }
};
