<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_pricing_tiers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('package_id')->constrained('ad_packages')->onDelete('cascade');
            
            $table->integer('validity_days'); // 1, 3, 7, 15, 30, etc.
            $table->integer('ad_limit')->nullable(); // For multiple ads packages
            
            $table->decimal('base_price', 10, 2);
            $table->decimal('discount_percentage', 5, 2)->nullable()->default(0);
            $table->decimal('final_price', 10, 2);
            
            $table->string('offer_label')->nullable(); // "Limited Time", "Best Value", etc.
            $table->boolean('is_popular')->default(false);
            $table->boolean('is_active')->default(true);
            
            $table->timestamps();
            
            // Indexes
            $table->index(['package_id', 'is_active']);
            $table->index('validity_days');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_pricing_tiers');
    }
};
