<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ad_packages', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->enum('type', ['multiple_ads', 'featured', 'boost', 'combo'])->index();
            $table->text('description')->nullable();
            
            // Features configuration (JSON)
            // Structure: {post_limit, featured_duration_days, boost_count, auto_boost_enabled, etc.}
            $table->json('features');
            
            // Algorithm parameters (JSON)
            // Structure: {featured_position_weight, boost_visibility_multiplier, etc.}
            $table->json('algorithm_params');
            
            $table->boolean('is_active')->default(true)->index();
            $table->integer('sort_order')->default(0);
            $table->text('terms')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['is_active', 'sort_order']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ad_packages');
    }
};
