<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('ad_images')) {
            Schema::create('ad_images', function (Blueprint $table) {
                $table->id();
                $table->foreignId('ad_id')->constrained()->onDelete('cascade');
                $table->string('image_url');
                $table->string('thumbnail_url')->nullable();
                $table->integer('order')->default(0); // For ordering images
                $table->boolean('is_primary')->default(false); // Primary/featured image
                $table->timestamps();

                // Indexes
                $table->index('ad_id');
                $table->index(['ad_id', 'is_primary']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ad_images');
    }
};
