<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Ad Networks Table
        Schema::create('ad_networks', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // 'admob', 'facebook'
            $table->string('display_name');
            $table->string('app_id')->nullable();
            $table->boolean('is_active')->default(false);
            $table->json('config')->nullable(); // For extra settings like test mode
            $table->timestamps();
        });

        // Seed initial networks
        DB::table('ad_networks')->insert([
            [
                'name' => 'admob',
                'display_name' => 'Google AdMob',
                'is_active' => false,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'facebook',
                'display_name' => 'Facebook Audience Network',
                'is_active' => false,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);

        // Ad Units Table
        Schema::create('ad_units', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ad_network_id')->constrained()->onDelete('cascade');
            $table->string('name'); // e.g., 'Home Banner', 'Post Detail Native'
            $table->string('placement_identifier'); // e.g., 'home_screen_banner' - mapped in app
            $table->string('type'); // 'banner', 'interstitial', 'native', 'rewarded', 'app_open'
            $table->string('ad_unit_id'); // The actual ID from AdMob/FAN
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ad_units');
        Schema::dropIfExists('ad_networks');
    }
};
