<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'city')) $table->string('city')->nullable();
            if (!Schema::hasColumn('users', 'state')) $table->string('state')->nullable();
            if (!Schema::hasColumn('users', 'country')) $table->string('country')->nullable();
            if (!Schema::hasColumn('users', 'latitude')) $table->decimal('latitude', 10, 8)->nullable();
            if (!Schema::hasColumn('users', 'longitude')) $table->decimal('longitude', 11, 8)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['city', 'state', 'country', 'latitude', 'longitude']);
        });
    }
};
