<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('algorithm_configs', function (Blueprint $table) {
            $table->id();
            $table->string('config_key')->unique();
            $table->json('weights')->nullable();
            $table->json('advanced_settings')->nullable();
            $table->json('vip_settings')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('version')->default(1);
            $table->timestamp('last_updated')->nullable();
            $table->timestamps();
            
            $table->index(['config_key', 'is_active']);
        });
        
        // Insert default algorithm configuration
        DB::table('algorithm_configs')->insert([
            [
                'config_key' => 'default',
                'weights' => json_encode([
                    'location_relevance' => 80,
                    'search_history' => 60,
                    'user_profile' => 70,
                    'ad_performance' => 90,
                    'freshness_factor' => 40,
                ]),
                'advanced_settings' => json_encode([
                    'learning_rate' => 0.7,
                    'memory_window' => 30,
                    'personalization' => true,
                    'diversity_factor' => 40,
                ]),
                'vip_settings' => json_encode([
                    'platinum_boost' => 100,
                    'gold_boost' => 75,
                    'silver_boost' => 50,
                    'free_boost' => 20,
                    'priority_ranking' => true,
                ]),
                'is_active' => true,
                'version' => 1,
                'last_updated' => now(),
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('algorithm_configs');
    }
};
