<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_plans', function (Blueprint $table) {
            // Add billing cycle support
            $table->decimal('monthly_price', 10, 2)->default(0.00)->after('price');
            $table->decimal('quarterly_price', 10, 2)->default(0.00)->after('monthly_price');
            $table->decimal('half_yearly_price', 10, 2)->default(0.00)->after('quarterly_price');
            $table->decimal('yearly_price', 10, 2)->default(0.00)->after('half_yearly_price');
            
            // Add billing cycle duration in months
            $table->integer('billing_cycle_months')->default(1)->after('duration_days');
            
            // Add discount support
            $table->decimal('discount_percentage', 5, 2)->default(0.00)->after('yearly_price');
            $table->decimal('discount_fixed_amount', 10, 2)->default(0.00)->after('discount_percentage');
            $table->timestamp('discount_start_date')->nullable()->after('discount_fixed_amount');
            $table->timestamp('discount_end_date')->nullable()->after('discount_start_date');
            
            // Add plan features for different billing cycles
            $table->boolean('enable_monthly')->default(true)->after('discount_end_date');
            $table->boolean('enable_quarterly')->default(true)->after('enable_monthly');
            $table->boolean('enable_half_yearly')->default(true)->after('enable_quarterly');
            $table->boolean('enable_yearly')->default(true)->after('enable_half_yearly');
            
            // Add promotional text
            $table->string('promotion_text')->nullable()->after('enable_yearly');
            $table->string('savings_text')->nullable()->after('promotion_text');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_plans', function (Blueprint $table) {
            $table->dropColumn([
                'monthly_price',
                'quarterly_price', 
                'half_yearly_price',
                'yearly_price',
                'billing_cycle_months',
                'discount_percentage',
                'discount_fixed_amount',
                'discount_start_date',
                'discount_end_date',
                'enable_monthly',
                'enable_quarterly',
                'enable_half_yearly',
                'enable_yearly',
                'promotion_text',
                'savings_text'
            ]);
        });
    }
};
