<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notification_targeting_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('notification_id')->constrained()->onDelete('cascade');
            $table->enum('target_type', ['user_id', 'plan_type', 'location', 'category', 'behavior', 'custom']);
            $table->json('target_value'); // Stores the actual target values
            $table->enum('operator', ['equals', 'in', 'not_in', 'contains', 'greater_than', 'less_than', 'between'])->default('equals');
            $table->string('deep_link_url')->nullable();
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['notification_id', 'target_type']);
            $table->index(['target_type', 'operator']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notification_targeting_rules');
    }
};
