<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_notification_preferences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->boolean('enabled')->default(true);
            $table->boolean('plan_notifications')->default(true);
            $table->boolean('category_notifications')->default(true);
            $table->boolean('location_notifications')->default(true);
            $table->boolean('deep_link_enabled')->default(true);
            $table->json('blocked_categories')->nullable(); // User can block specific categories
            $table->json('blocked_locations')->nullable(); // User can block specific locations
            $table->time('quiet_hours_start')->nullable(); // Start of quiet hours
            $table->time('quiet_hours_end')->nullable(); // End of quiet hours
            $table->timestamps();
            
            // Unique constraint to ensure one preference per user
            $table->unique('user_id');
            
            // Indexes for performance
            $table->index(['user_id', 'enabled']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_notification_preferences');
    }
};
