<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('analytics_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('event_type');
            $table->json('event_data')->nullable();
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->string('session_id')->nullable();
            $table->string('referrer')->nullable();
            $table->string('page_url')->nullable();
            $table->string('country')->default('Unknown');
            $table->string('city')->default('Unknown');
            $table->enum('device_type', ['Desktop', 'Mobile', 'Tablet', 'Unknown'])->default('Unknown');
            $table->string('browser')->default('Unknown');
            $table->string('os')->default('Unknown');
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['event_type']);
            $table->index(['user_id']);
            $table->index(['session_id']);
            $table->index(['created_at']);
            $table->index(['device_type']);
            $table->index(['browser']);
            $table->index(['country']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('analytics_events');
    }
};
