<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_plans', function (Blueprint $table) {
            $table->id();
            $table->string('plan_name');
            $table->decimal('price', 10, 2)->default(0.00);
            $table->decimal('price_multiplier', 5, 2)->default(1.00);
            $table->integer('duration_days')->default(30);
            $table->decimal('city_multiplier', 5, 2)->default(1.00);
            $table->integer('post_limit')->nullable();
            $table->integer('lead_limit')->nullable();
            $table->string('analytics_tier')->default('basic');
            $table->integer('validity_days')->default(30);
            $table->boolean('ad_free')->default(false);
            $table->boolean('has_analytics')->default(false);
            $table->boolean('verified_badge')->default(false);
            $table->string('badge_style')->nullable();
            $table->string('theme')->nullable();
            $table->string('halo_effect')->nullable();
            $table->string('ad_border')->nullable();
            $table->string('status')->default('Active');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_plans');
    }
};
