<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('safety_actions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            
            // Temporarily commented to fix migration order - will re-add after ads table exists
            // $table->foreignId('ad_id')->nullable()->constrained('ads')->onDelete('cascade');
            $table->unsignedBigInteger('ad_id')->nullable(); // Temporary placeholder
            
            $table->foreignId('report_id')->nullable()->constrained('safety_reports')->onDelete('set null');
            $table->string('action_type'); // auto_suspend, auto_delete, warning, restriction, manual_review
            $table->text('reason');
            $table->boolean('auto_generated')->default(true);
            $table->foreignId('admin_id')->nullable()->constrained('users')->onDelete('set null');
            $table->json('action_data')->nullable(); // Additional data about the action
            $table->timestamp('expires_at')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['user_id', 'action_type', 'is_active']);
            $table->index(['auto_generated', 'created_at']);
            $table->index(['expires_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('safety_actions');
    }
};
