<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_trust_scores', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->integer('score')->default(50);
            $table->string('tier')->default('trusted'); // new, trusted, highly_trusted, elite, legend
            $table->json('breakdown'); // Detailed breakdown of score components
            $table->integer('penalty_points')->default(0);
            $table->timestamp('last_calculated')->nullable();
            $table->boolean('is_suspended')->default(false);
            $table->timestamp('suspension_until')->nullable();
            $table->text('suspension_reason')->nullable();
            $table->timestamps();
            
            // Unique constraint
            $table->unique('user_id');
            
            // Indexes for performance
            $table->index(['score', 'tier']);
            $table->index(['is_suspended', 'suspension_until']);
            $table->index('last_calculated');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_trust_scores');
    }
};
