<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('safety_reports')) {
            Schema::create('safety_reports', function (Blueprint $table) {
                $table->id();
                $table->foreignId('reported_user_id')->constrained('users')->onDelete('cascade');
                // Temporarily commented to fix migration order - will re-add after ads table exists
                // $table->foreignId('ad_id')->nullable()->constrained('ads')->onDelete('set null');
                $table->unsignedBigInteger('ad_id')->nullable(); // Temporary placeholder
                $table->string('report_type'); // scam, fake, spam, inappropriate, other
                $table->text('description')->nullable();
                $table->foreignId('reporter_id')->nullable()->constrained('users')->onDelete('set null');
                $table->enum('status', ['pending', 'reviewed', 'action_taken', 'dismissed'])->default('pending');
                $table->boolean('is_anonymous')->default(false);
                $table->json('evidence')->nullable(); // Store screenshots, metadata
                $table->foreignId('admin_id')->nullable()->constrained('users')->onDelete('set null');
                $table->timestamp('reviewed_at')->nullable();
                $table->text('admin_notes')->nullable();
                $table->timestamps();
                
                // Indexes for performance
                $table->index(['status', 'created_at']);
                $table->index(['reported_user_id', 'status']);
                $table->index(['report_type', 'status']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('safety_reports');
    }
};
