<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Only add location fields to users table if they don't exist
        if (Schema::hasTable('users')) {
            Schema::table('users', function (Blueprint $table) {
                if (!Schema::hasColumn('users', 'country')) {
                    $table->string('country')->nullable()->after('bio');
                }
                if (!Schema::hasColumn('users', 'state')) {
                    $table->string('state')->nullable()->after('country');
                }
                if (!Schema::hasColumn('users', 'city')) {
                    $table->string('city')->nullable()->after('state');
                }
                if (!Schema::hasColumn('users', 'area')) {
                    $table->string('area')->nullable()->after('city');
                }
                if (!Schema::hasColumn('users', 'address')) {
                    $table->string('address')->nullable()->after('area');
                }
                if (!Schema::hasColumn('users', 'latitude')) {
                    $table->decimal('latitude', 10, 8)->nullable()->after('address');
                }
                if (!Schema::hasColumn('users', 'longitude')) {
                    $table->decimal('longitude', 11, 8)->nullable()->after('latitude');
                }
                if (!Schema::hasColumn('users', 'location_accuracy')) {
                    $table->string('location_accuracy')->default('city')->after('longitude');
                }
                if (!Schema::hasColumn('users', 'share_location')) {
                    $table->boolean('share_location')->default(true)->after('location_accuracy');
                }
                if (!Schema::hasColumn('users', 'location_updated_at')) {
                    $table->timestamp('location_updated_at')->nullable()->after('share_location');
                }
            });
        }

        // Only add location fields to ads table if it exists
        if (Schema::hasTable('ads')) {
            Schema::table('ads', function (Blueprint $table) {
                if (!Schema::hasColumn('ads', 'country')) {
                    $table->string('country')->nullable()->after('description');
                }
                if (!Schema::hasColumn('ads', 'state')) {
                    $table->string('state')->nullable()->after('country');
                }
                if (!Schema::hasColumn('ads', 'city')) {
                    $table->string('city')->nullable()->after('state');
                }
                if (!Schema::hasColumn('ads', 'area')) {
                    $table->string('area')->nullable()->after('city');
                }
                if (!Schema::hasColumn('ads', 'address')) {
                    $table->string('address')->nullable()->after('area');
                }
                if (!Schema::hasColumn('ads', 'latitude')) {
                    $table->decimal('latitude', 10, 8)->nullable()->after('address');
                }
                if (!Schema::hasColumn('ads', 'longitude')) {
                    $table->decimal('longitude', 11, 8)->nullable()->after('latitude');
                }
                if (!Schema::hasColumn('ads', 'location_accuracy')) {
                    $table->string('location_accuracy')->default('city')->after('longitude');
                }
            });
        }

        // Create location history table
        Schema::create('location_histories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('country')->nullable();
            $table->string('state')->nullable();
            $table->string('city')->nullable();
            $table->string('area')->nullable();
            $table->string('address')->nullable();
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->string('location_source')->default('gps');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'country', 'state', 'city', 'area', 'address', 
                'latitude', 'longitude', 'location_accuracy', 
                'share_location', 'location_updated_at'
            ]);
        });

        Schema::table('ads', function (Blueprint $table) {
            $table->dropColumn([
                'country', 'state', 'city', 'area', 'address', 
                'latitude', 'longitude', 'location_accuracy'
            ]);
        });

        Schema::dropIfExists('location_histories');
    }
};
