<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Profile Picture
            $table->string('profile_picture')->nullable()->after('mobile_number');
            
            // Profile Bio
            $table->text('bio')->nullable()->after('profile_picture');
            
            // Member Since (Registration Date)
            $table->timestamp('member_since')->nullable()->after('bio');
            
            // Followers Count
            $table->integer('followers_count')->default(0)->after('member_since');
            
            // Following Count
            $table->integer('following_count')->default(0)->after('followers_count');
            
            // Verification Badge
            $table->boolean('has_verification_badge')->default(false)->after('following_count');
            $table->timestamp('verification_badge_purchased_at')->nullable()->after('has_verification_badge');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'profile_picture',
                'bio',
                'member_since',
                'followers_count',
                'following_count',
                'has_verification_badge',
                'verification_badge_purchased_at'
            ]);
        });
    }
};
