<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('is_admin')->default(false)->after('password');
            $table->boolean('is_verified')->default(false)->after('is_admin');
            $table->string('google_id')->nullable()->after('password');
            $table->string('phone_number')->nullable()->after('google_id');
            $table->string('profile_image')->nullable()->after('phone_number');
            $table->unsignedBigInteger('current_plan_id')->nullable()->after('profile_image');
            $table->string('verified_badge_style')->nullable()->after('is_verified');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
};
