<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('ads')) {
            Schema::create('ads', function (Blueprint $table) {
                $table->id();
                $table->foreignId('user_id')->constrained()->onDelete('cascade');
                $table->foreignId('category_id')->nullable()->constrained()->onDelete('set null');
                $table->foreignId('subcategory_id')->nullable()->constrained()->onDelete('set null');
                $table->string('title');
                $table->text('description');
                $table->decimal('price', 10, 2);
                $table->string('currency')->default('INR');
                $table->string('condition')->nullable(); // new, used, refurbished
                $table->string('status')->default('pending'); // pending, approved, rejected, expired
                $table->string('ad_type')->default('standard'); // standard, premium, featured
                $table->string('contact_method')->default('phone'); // phone, email, whatsapp, messenger
                $table->string('contact_phone')->nullable();
                $table->string('contact_email')->nullable();
                $table->string('contact_whatsapp')->nullable();
                $table->string('location_city')->nullable();
                $table->string('location_state')->nullable();
                $table->string('location_country')->nullable();
                $table->string('location_address')->nullable();
                $table->decimal('location_latitude', 10, 8)->nullable();
                $table->decimal('location_longitude', 11, 8)->nullable();
                $table->integer('view_count')->default(0);
                $table->integer('favorite_count')->default(0);
                $table->integer('share_count')->default(0);
                $table->timestamp('approved_at')->nullable();
                $table->timestamp('expires_at')->nullable();
                $table->timestamp('featured_until')->nullable();
                $table->boolean('is_active')->default(true);
                $table->boolean('is_verified')->default(false);
                $table->boolean('is_sponsored')->default(false);
                $table->text('admin_notes')->nullable();
                $table->timestamps();
                $table->softDeletes();
                
                // Indexes for performance
                $table->index(['status', 'is_active']);
                $table->index(['category_id', 'subcategory_id']);
                $table->index(['user_id']);
                $table->index(['approved_at']);
                $table->index(['expires_at']);
                $table->index(['featured_until']);
                $table->index(['view_count']);
                $table->index(['location_city', 'location_state']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ads');
    }
};
