<?php

// Simple script to create user_plans table and insert sample data
// Run this directly in your browser: http://127.0.0.1:8000/create_user_plans_table.php

require_once __DIR__ . '/vendor/autoload.php';

// Create a simple Laravel application instance
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use Illuminate\Support\Facades\DB;

try {
    // Check if table exists
    $tables = DB::select("SELECT name FROM sqlite_master WHERE type='table' AND name='user_plans';");
    
    if (empty($tables)) {
        // Create the table
        DB::statement("
            CREATE TABLE user_plans (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                plan_name TEXT NOT NULL,
                price DECIMAL(10,2) DEFAULT 0.00,
                price_multiplier DECIMAL(5,2) DEFAULT 1.00,
                duration_days INTEGER DEFAULT 30,
                city_multiplier DECIMAL(5,2) DEFAULT 1.00,
                post_limit INTEGER NULL,
                lead_limit INTEGER NULL,
                analytics_tier TEXT DEFAULT 'basic',
                validity_days INTEGER DEFAULT 30,
                ad_free BOOLEAN DEFAULT 0,
                has_analytics BOOLEAN DEFAULT 0,
                verified_badge BOOLEAN DEFAULT 0,
                badge_style TEXT NULL,
                theme TEXT NULL,
                halo_effect TEXT NULL,
                ad_border TEXT NULL,
                status TEXT DEFAULT 'Active',
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                deleted_at DATETIME NULL
            )
        ");
        
        echo "<h2 style='color: green;'>✅ Table 'user_plans' created successfully!</h2>";
    } else {
        echo "<h2 style='color: blue;'>ℹ️ Table 'user_plans' already exists</h2>";
    }
    
    // Check if we have data
    $count = DB::table('user_plans')->count();
    
    if ($count == 0) {
        // Insert sample data
        DB::table('user_plans')->insert([
            [
                'plan_name' => 'Standard',
                'price' => 0.00,
                'duration_days' => 30,
                'post_limit' => 5,
                'lead_limit' => 10,
                'analytics_tier' => 'basic',
                'validity_days' => 30,
                'ad_free' => false,
                'has_analytics' => true,
                'verified_badge' => false,
                'theme' => 'standard',
                'status' => 'Active',
            ],
            [
                'plan_name' => 'VIP Buyer',
                'price' => 19.99,
                'duration_days' => 30,
                'analytics_tier' => 'advanced',
                'validity_days' => 30,
                'ad_free' => false,
                'has_analytics' => true,
                'verified_badge' => true,
                'badge_style' => 'blue_vip',
                'theme' => 'vip_buyer_theme',
                'halo_effect' => 'blue_glow',
                'ad_border' => 'blue_border',
                'status' => 'Active',
            ],
            [
                'plan_name' => 'VIP Seller',
                'price' => 24.99,
                'duration_days' => 30,
                'post_limit' => 50,
                'lead_limit' => 100,
                'analytics_tier' => 'premium',
                'validity_days' => 30,
                'ad_free' => false,
                'has_analytics' => true,
                'verified_badge' => true,
                'badge_style' => 'gold_vip',
                'theme' => 'vip_seller_theme',
                'halo_effect' => 'gold_glow',
                'ad_border' => 'gold_border',
                'status' => 'Active',
            ],
            [
                'plan_name' => 'VIP Pro',
                'price' => 39.99,
                'duration_days' => 30,
                'post_limit' => 200,
                'lead_limit' => 500,
                'analytics_tier' => 'enterprise',
                'validity_days' => 30,
                'ad_free' => true,
                'has_analytics' => true,
                'verified_badge' => true,
                'badge_style' => 'purple_premium',
                'theme' => 'vip_pro_theme',
                'halo_effect' => 'purple_glow',
                'ad_border' => 'purple_border',
                'status' => 'Active',
            ]
        ]);
        
        echo "<h2 style='color: green;'>✅ Sample data inserted successfully!</h2>";
    } else {
        echo "<h2 style='color: blue;'>ℹ️ Sample data already exists ($count records)</h2>";
    }
    
    echo "<h3 style='color: green;'>🎉 SUCCESS! Your Premium Plan system is now ready!</h3>";
    echo "<p><a href='/admin/plans' style='font-size: 18px; color: #7c3aed; text-decoration: none; border: 2px solid #7c3aed; padding: 10px 20px; border-radius: 5px;'>Go to Admin Plans Dashboard →</a></p>";
    
} catch (Exception $e) {
    echo "<h2 style='color: red;'>❌ Error: " . $e->getMessage() . "</h2>";
    echo "<p>Please check your database connection and try again.</p>";
}

echo "<hr>";
echo "<p><strong>Manual Alternative:</strong> If this doesn't work, you can manually run the SQL from <code>database/user_plans_setup.sql</code></p>";
?>
