<?php

// Create test user with known credentials
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

echo "=== CREATING TEST USER ===\n\n";

$email = 'test@clxpro.in';
$password = 'Test@123';
$name = 'Test User';

// Check if user exists
$existingUser = DB::table('users')->where('email', $email)->first();

if ($existingUser) {
    echo "User already exists! Updating password...\n";
    DB::table('users')->where('email', $email)->update([
        'password' => Hash::make($password),
        'updated_at' => now()
    ]);
    $userId = $existingUser->id;
} else {
    echo "Creating new user...\n";
    $userId = DB::table('users')->insertGetId([
        'name' => $name,
        'email' => $email,
        'password' => Hash::make($password),
        'email_verified_at' => now(),
        'created_at' => now(),
        'updated_at' => now()
    ]);
}

// Assign default plan
$defaultPlan = DB::table('user_plans')->where('is_default', true)->first();

if ($defaultPlan) {
    DB::table('users')->where('id', $userId)->update([
        'current_plan_id' => $defaultPlan->id,
        'plan_expires_at' => now()->addDays($defaultPlan->validity_days),
        'membership_type' => $defaultPlan->plan_name,
        'updated_at' => now()
    ]);
    
    $user = DB::table('users')->find($userId);
    
    echo "\n✅ TEST USER CREATED/UPDATED!\n\n";
    echo "═══════════════════════════════════\n";
    echo "📧 EMAIL:    {$email}\n";
    echo "🔑 PASSWORD: {$password}\n";
    echo "═══════════════════════════════════\n\n";
    echo "User Details:\n";
    echo "  ID: {$user->id}\n";
    echo "  Name: {$user->name}\n";
    echo "  Current Plan: {$defaultPlan->plan_name}\n";
    echo "  Plan ID: {$defaultPlan->id}\n";
    echo "  Expires: {$user->plan_expires_at}\n\n";
    
    echo "🎯 You can now login in the Flutter app with:\n";
    echo "   Email: {$email}\n";
    echo "   Password: {$password}\n\n";
    echo "✅ This user has '{$defaultPlan->plan_name}' plan assigned!\n";
    echo "✅ Premium Plans screen should show 'Current Plan ✓' on Standard\n";
} else {
    echo "❌ No default plan found!\n";
}
