<?php

// Simple script to populate demo users and ads
require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\User;
use App\Models\Ad;
use App\Models\Category;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;

echo "Creating demo users and ads...\n\n";

// Create demo users
$users = [
    [
        'name' => 'Raj Kumar',
        'email' => 'raj@example.com',
        'mobile_number' => '+919876543210',
        'city' => 'Mumbai',
        'state' => 'Maharashtra',
        'country' => 'India'
    ],
    [
        'name' => 'Priya Sharma',
        'email' => 'priya@example.com',
        'mobile_number' => '+919876543211',
        'city' => 'Delhi',
        'state' => 'Delhi',
        'country' => 'India'
    ],
    [
        'name' => 'Amit Patel',
        'email' => 'amit@example.com',
        'mobile_number' => '+919876543212',
        'city' => 'Bangalore',
        'state' => 'Karnataka',
        'country' => 'India'
    ],
    [
        'name' => 'Sneha Reddy',
        'email' => 'sneha@example.com',
        'mobile_number' => '+919876543213',
        'city' => 'Hyderabad',
        'state' => 'Telangana',
        'country' => 'India'
    ],
    [
        'name' => 'Vikram Singh',
        'email' => 'vikram@example.com',
        'mobile_number' => '+919876543214',
        'city' => 'Pune',
        'state' => 'Maharashtra',
        'country' => 'India'
    ]
];

$createdUsers = [];
foreach ($users as $userData) {
    $user = User::updateOrCreate(
        ['email' => $userData['email']],
        array_merge($userData, [
            'password' => Hash::make('password123'),
            'email_verified_at' => now(),
            'is_admin' => false
        ])
    );
    $createdUsers[] = $user;
    echo "✓ Created user: {$user->name} ({$user->email})\n";
}

echo "\n";

// Get all available categories
$categories = Category::all();
echo "Found " . $categories->count() . " categories\n\n";

if ($categories->isEmpty()) {
    echo "ERROR: No categories found. Please run CategoriesSeeder first.\n";
    exit(1);
}

// Create demo ads for each category
$adTitles = [
    'iPhone 14 Pro Max 256GB',
    'Samsung Galaxy S23 Ultra',
    'MacBook Pro M2 2023',
    'Dell XPS 15 Laptop',
    'Sony WH-1000XM5 Headphones',
    'iPad Air 2023',
    'Canon EOS R6 Camera',
    'LG 55" OLED TV',
    'PlayStation 5',
    'Nintendo Switch OLED',
    'Honda City 2020 Model',
    'Royal Enfield Classic 350',
    '2BHK Apartment for Rent',
    '3BHK Independent House',
    'L-Shaped Sofa Set - Grey',
    'Study Table with Chair',
    'Dining Table - 6 Seater',
    'King Size Bed Frame',
    'Mountain Bike 21 Speed',
    'Treadmill - Like New'
];

$descriptions = [
    'Excellent condition, barely used. All accessories included.',
    'Brand new, sealed pack with warranty.',
    'Well maintained, single owner, full service history.',
    'Premium quality, like new condition. Moving sale.',
    'Urgent sale, price negotiable. Serious buyers only.',
    'Great condition, no issues. Ready to use.',
    'Almost new, used only few times. Original box available.',
    'Perfect working condition. Best price in market.',
];

echo "Creating demo ads...\n";
$adsCreated = 0;

foreach ($createdUsers as $index => $user) {
    // Create 3-4 ads per user
    $numberOfAds = rand(3, 4);
    
    for ($i = 0; $i < $numberOfAds; $i++) {
        $category = $categories->random();
        $titleIndex = ($index * $numberOfAds + $i) % count($adTitles);
        
        $ad = Ad::create([
            'user_id' => $user->id,
            'category_id' => $category->id,
            'title' => $adTitles[$titleIndex],
            'description' => $descriptions[array_rand($descriptions)],
            'price' => rand(5000, 500000),
            'currency' => 'INR',
            'location_city' => $user->city,
            'location_state' => $user->state,
            'location_country' => $user->country,
            'status' => ['Active', 'Active', 'Active', 'Pending'][rand(0, 3)],
            'view_count' => rand(10, 1000),
            'favorite_count' => rand(0, 100),
            'share_count' => rand(0, 50),
            'is_featured' => rand(0, 4) == 0, // 20% chance
            'is_active' => true,
            'created_at' => Carbon::now()->subDays(rand(1, 30)),
            'updated_at' => Carbon::now()->subDays(rand(0, 10))
        ]);
        
        $adsCreated++;
        echo "  ✓ {$ad->title} by {$user->name} in {$category->name}\n";
    }
}

echo "\n";
echo "✅ Successfully created:\n";
echo "   - " . count($createdUsers) . " demo users\n";
echo "   - $adsCreated demo ads\n";
echo "\nLogin credentials for demo users:\n";
echo "   Email: raj@example.com, priya@example.com, etc.\n";
echo "   Password: password123\n";
