<?php

// Check specific user test@clxpro.in
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

$email = 'test@clxpro.in';

echo "=== CHECKING USER: {$email} ===\n\n";

$user = DB::table('users')->where('email', $email)->first();

if (!$user) {
    echo "❌ User not found!\n";
    echo "Available users:\n";
    $users = DB::table('users')->select('id', 'email', 'name')->limit(10)->get();
    foreach ($users as $u) {
        echo "  - {$u->email} ({$u->name})\n";
    }
    exit(1);
}

echo "User Details:\n";
echo "  Name: {$user->name}\n";
echo "  ID: {$user->id}\n";
echo "  Email: {$user->email}\n";
echo "  Current Plan ID: " . ($user->current_plan_id ?? 'NULL') . "\n";
echo "  Membership Type: " . ($user->membership_type ?? 'NULL') . "\n";
echo "  Plan Expires: " . ($user->plan_expires_at ?? 'NULL') . "\n\n";

if (!$user->current_plan_id) {
    echo "⚠️  User has NO plan assigned!\n";
    echo "Assigning default plan...\n\n";
    
    $defaultPlan = DB::table('user_plans')->where('is_default', true)->first();
    if ($defaultPlan) {
        DB::table('users')->where('id', $user->id)->update([
            'current_plan_id' => $defaultPlan->id,
            'plan_expires_at' => now()->addDays($defaultPlan->validity_days),
            'membership_type' => $defaultPlan->plan_name,
            'updated_at' => now()
        ]);
        echo "✅ Assigned '{$defaultPlan->plan_name}' to {$user->name}\n";
    }
} else {
    $plan = DB::table('user_plans')->find($user->current_plan_id);
    if ($plan) {
        echo "Current Plan:\n";
        echo "  Plan Name: {$plan->plan_name}\n";
        echo "  Price: ₹{$plan->price}\n";
        echo "  Status: {$plan->status}\n";
        echo "  Is Default: " . ($plan->is_default ? 'Yes' : 'No') . "\n";
    }
}

echo "\n=== API SIMULATION ===\n";
echo "When user logs in, /api/plans will return:\n";
echo "  current_plan_id: " . ($user->current_plan_id ?? 'NULL') . "\n";
echo "\nFlutter app will compare each plan's ID with current_plan_id:\n";

$plans = DB::table('user_plans')->where('status', 'Active')->get();
foreach ($plans as $p) {
    $isCurrent = $user->current_plan_id == $p->id;
    $display = $isCurrent ? 'Current Plan ✓' : 'Upgrade to ' . $p->plan_name;
    echo "  - {$p->plan_name} (ID: {$p->id}): [{$display}]\n";
}
