<?php

// Check and add is_default column to user_plans table
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

echo "Checking user_plans table for is_default column...\n";

try {
    // Check if column exists
    $columns = DB::select("SHOW COLUMNS FROM user_plans LIKE 'is_default'");
    
    if (empty($columns)) {
        echo "Column 'is_default' does not exist. Adding it now...\n";
        DB::statement("ALTER TABLE user_plans ADD COLUMN is_default TINYINT(1) DEFAULT 0 AFTER status");
        echo "✅ Column added successfully!\n";
        
        // Set Standard as default
        DB::table('user_plans')
            ->where('plan_name', 'Standard')
            ->update(['is_default' => true]);
        echo "✅ Set 'Standard' as default plan\n";
    } else {
        echo "✅ Column 'is_default' already exists!\n";
        
        // Show current default plan
        $defaultPlan = DB::table('user_plans')->where('is_default', true)->first();
        if ($defaultPlan) {
            echo "Current default plan: {$defaultPlan->plan_name}\n";
        } else {
            echo "No default plan set. Setting Standard as default...\n";
            DB::table('user_plans')
                ->where('plan_name', 'Standard')
                ->update(['is_default' => true]);
            echo "✅ Set 'Standard' as default plan\n";
        }
    }
    
    echo "\n All plans:\n";
    $plans = DB::table('user_plans')->select('id', 'plan_name', 'is_default')->get();
    foreach ($plans as $plan) {
        $default = $plan->is_default ? ' (DEFAULT)' : '';
        echo "  - {$plan->plan_name}{$default}\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}
