<?php

// Simple admin user verification script
require_once __DIR__ . '/vendor/autoload.php';

// Bootstrap Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

echo "Checking Admin User...\n";
echo "=====================\n\n";

$adminEmail = 'admin@donebro.in';

try {
    $adminUser = DB::table('users')
        ->where('email', $adminEmail)
        ->where('is_admin', true)
        ->first();
    
    if ($adminUser) {
        echo "✓ Admin user found!\n";
        echo "Name: {$adminUser->name}\n";
        echo "Email: {$adminUser->email}\n";
        echo "Verified: " . ($adminUser->is_verified ? 'Yes' : 'No') . "\n";
        echo "Admin Status: " . ($adminUser->is_admin ? 'Yes' : 'No') . "\n";
        echo "\n✓ Database reset successful with persistent admin access!\n";
        echo "\nAdmin Access Details:\n";
        echo "Email: admin@donebro.in\n";
        echo "Password: 123456\n";
        echo "Dashboard URL: /admin/login\n";
    } else {
        echo "✗ Admin user not found!\n";
        echo "The database may need to be seeded properly.\n";
    }
} catch (\Exception $e) {
    echo "✗ Error checking admin user: " . $e->getMessage() . "\n";
}

?>
