<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // specific view composer for settings to share common data if needed
        
        // Register Guardian Listeners
        \Illuminate\Support\Facades\Event::listen(
            \App\Events\ReportCreated::class,
            \App\Listeners\MonitorAdActivity::class
        );

        \Illuminate\Support\Facades\Event::listen(
            \App\Events\MessageSent::class,
            \App\Listeners\ScanChatMessage::class
        );

        try {
            // Load mail settings from database if they exist
            if (\Schema::hasTable('settings')) {
                $mailSettings = \App\Models\Setting::where('key', 'like', 'mail_%')->pluck('value', 'key');
                
                if ($mailSettings->isNotEmpty()) {
                    if (isset($mailSettings['mail_host'])) {
                        \Config::set('mail.mailers.smtp.host', $mailSettings['mail_host']);
                    }
                    if (isset($mailSettings['mail_port'])) {
                        \Config::set('mail.mailers.smtp.port', $mailSettings['mail_port']);
                    }
                    if (isset($mailSettings['mail_username'])) {
                        \Config::set('mail.mailers.smtp.username', $mailSettings['mail_username']);
                    }
                    if (isset($mailSettings['mail_password'])) {
                        \Config::set('mail.mailers.smtp.password', $mailSettings['mail_password']);
                    }
                    if (isset($mailSettings['mail_encryption'])) {
                        \Config::set('mail.mailers.smtp.encryption', $mailSettings['mail_encryption']);
                    }
                    if (isset($mailSettings['mail_from_address'])) {
                        \Config::set('mail.from.address', $mailSettings['mail_from_address']);
                    }
                    if (isset($mailSettings['mail_from_name'])) {
                        \Config::set('mail.from.name', $mailSettings['mail_from_name']);
                    }
                }
            }
        } catch (\Exception $e) {
            // Fallback to .env defaults if DB fails
        }
    }
}
